package com.android.browser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import android.content.Context;
import android.util.Log;

/**
 * I write a plain text file instead of using shared preference for 3 reasons:
 * 		1) Keeps native android preference separate from crestron related settings
 * 		2) Don't need to handle XML parsing, this is simpler and quicker.
 * 		3) Mobile Value is stored as a weakhashmap probably in db, but not in flat file which i can't find atm in code
 * @author Walter
 *
 */
public class UAFileHandler  {

    private static final String TAG = "UAFileReader";
	private File uaPreferenceFile;
	private String filePath = "/data/data/com.android.browser/crestron_user_agent.txt";

	/**
	 * onResume() read preference to check to see if setting was changed while closed
	 * @return
	 */
	public boolean readUAPref(){
		
			BufferedReader br = null;
			boolean isDesktopBrowser = false;
			uaPreferenceFile = new File(filePath);
			if (!uaPreferenceFile.exists()) {
				try {
					uaPreferenceFile.createNewFile();
				} catch (IOException e) {
					Log.e(TAG, "Could not write preference file, returning false.", e);
					return false;
				}
			}
			
			try {
					br = new BufferedReader(new FileReader(uaPreferenceFile));
					
					String input = null;
					if(br != null){
						input = br.readLine();
					}
					
					if(input != null){
						if(input.trim().equals("true")){
							isDesktopBrowser = true;
						}
					}
						
					br.close();
					

			} catch (Exception e) {
				Log.e(TAG, "Could not read files", e);
				br = null;
			}
	
//			 Log.i(TAG,"User agent file returned:" + isDesktopBrowser);
			 return isDesktopBrowser;
	}

	public void writePref(boolean isDesktopUserAgent) {
		BufferedWriter br = null;
		uaPreferenceFile = new File(filePath);
		if (!uaPreferenceFile.exists()) {
			try {
				uaPreferenceFile.createNewFile();
			} catch (IOException e) {
				Log.e(TAG, "Could not write preference file.", e);
				return;
			}
		}
		try {
				br = new BufferedWriter(new FileWriter(uaPreferenceFile));
				if (isDesktopUserAgent)
					br.write("true\n");
				else
					br.write("false\n");
				
				br.flush();
				br.close();
			
		} catch (Exception e) {
			Log.e(TAG, "Could not read files", e);
			br = null;
		}

//		Log.i(TAG, "ua file set to:" + isDesktopUserAgent);
	}

}

